function dydt = synchnegpos_noHe_2eqns(t, y, Z, parameters)
global ng;
% TDQS1 negative feedback delay equations

% Variables
A                 = y(1);
Hi                = y(2);
He                = y(3);
I                 = y(4);

% Delayed Variables
Htau              = Z(2);


% Parameters
alpha=parameters(1);
gamma_ae=parameters(2);
gamma_a=parameters(3);
gamma_ah=parameters(4);
gamma_h=parameters(5);
f=parameters(6);
g=parameters(7);
b=parameters(8);
%c_i=parameters(9);
k=parameters(10);
%gamma_i=parameters(11);
c_a=parameters(12);
D=parameters(13);
gamma_He=parameters(14);
k1=parameters(15);
gamma_i=parameters(16);
c_i=parameters(17);
gamma_ie=parameters(18);
% Zero array
dydt = zeros(4, 1);

% Equations
Pk=(1+alpha*Htau^2)/(1+k1*Htau^2);  % 2->3?

dydt(1) = c_a*Pk-gamma_ae*A/(1+f*(A+I))-gamma_a*A;
dydt(2) = b*I/(1+k*I)-gamma_ah*Hi*A/(1+g*A)-gamma_h*Hi +D*(He-Hi);
dydt(3) = -D*(He-Hi)-gamma_He*He; 
dydt(4) = c_i*Pk-gamma_ie*I/(1+f*(A+I))-gamma_i*I;

